; ***************************************************
; BURNER06.BIN
;                 
; Prog: MUSIC ASSEMBLER FOR VIDEOGAME KILL MICE
; Code: TIMER INTERRUPT HOOK ASSEMBLER Z80
; Date: 9/12/2012
;
; MUSIC for LEVEL-7 BURNER BURST
;
; cmnt: Andrea Gasparrini 2011
;
; Coded in TeddyWareZ' Chaos Assembler 3
;
; (C) 2012 GAMECAST Entertainment
; ****************************************************


	.org $B500 - 7

	.db $fe
	.dw startProgram,endProgram,startProgram

startProgram:
;*************************************************************
;   List 2.4   How to use HOOK safety
;	       This routine uses TIMER INTERRUPT HOOK
;				   
;	       To start play,     do  DEF USR=&HC000 : A=USR(0)
;            To continue music, do  DEF USR=&HC030 A=USR(0) 
;	       To pause music,    do  DEF USR=&HC050 : A=USR(0)
;*************************************************************
;
CHGCAP .EQU	0132H		;CAPS LAMP on/off
CAPST	 .EQU	0FCABH		;CAPS LOCK status
TIMI	 .EQU	0FD9FH		;timer interrupt hook
JPCODE .EQU	0C3H
TIMER	 .EQU	020H


;----- interrupt on ----- Note:  restore the former hook
				 ;when changing the hook
      
 CALL START  ; load and initialize STAR MUSIC

 .ORG $B520   ; CONTINUE MUSIC

INTON:	
      DI
	LD	HL,TIMI 	;OLD HOOK SAVE
	LD	DE,HKSAVE
	LD	BC,5
	LDIR

	LD	A,JPCODE	;NEW HOOK SET
	LD	(TIMI),A
	LD	HL,INT
	LD	(TIMI+1),HL
	EI
	RET

	.ORG	$B550  ; PAUSE MUSIC

;----- interrupt off ----- Note:  restore the reserved hook and exit

INTOFF:
      DI
	LD	HL,HKSAVE
	LD	DE,TIMI
	LD	BC,5
	LDIR
	EI  
	CALL $90 ; resetta canale audio
	RET

;----- interrupt routine -----

INT:	PUSH	AF
	LD	A,(CAPST)
	OR	A
	JR	Z,CAPON

CAPOFF: 
   CALL MUTE  ; silence

CAPON:
   CALL PLAY  ; play 1 quark
   
FIN:
 	POP	AF
	CALL	HKSAVE		;old HOOK call

	RET

COUNT1:           
      .DB TIMER
COUNT2:
      .DB TIMER

HKSAVE: 
      NOP			;old HOOK save area
	NOP
	NOP
	NOP
	RET   

;----- interrupt routine -----

#INCLUDE "pt3.asm"
#INCLUDE "burnerburstmusic7pt3.asm"
endProgram:

.end
